// Upgrade NOTE: replaced 'mul(UNITY_MATRIX_MVP,*)' with 'UnityObjectToClipPos(*)'
// https://forum.unity.com/threads/issues-creating-fixed-width-lines-using-geometry-shader-in-view-space.442178/
Shader "Unlit/LineShader_urp"
{
    Properties
    {
        _MainTex("Texture", 2D) = "white" {}
        _Thickness("Line Width", Range(1,100)) = 5
    }
        SubShader
        {
            Tags { "RenderType" = "Opaque" }
            LOD 100

            Pass
            {
                CGPROGRAM
                #pragma vertex vert
                #pragma geometry geom
                #pragma fragment frag
                // make fog work
                #pragma multi_compile_fog

                #include "UnityCG.cginc"

                struct appdata
                {
                    float4 vertex : POSITION;
                    float2 uv : TEXCOORD0;
                };

                struct v2g
                {
                    float4 vertex : POSITION;
                    float2 uv : TEXCOORD0;
                };

                struct g2f
                {
                    float2 uv : TEXCOORD0;
                    UNITY_FOG_COORDS(1)
                    float4 vertex : SV_POSITION;
                };

                sampler2D _MainTex;
                float4 _MainTex_ST;
                float _Thickness;

                v2g vert(appdata v)
                {
                    v2g o;
                    o.vertex = UnityObjectToClipPos(v.vertex);
                    o.uv = TRANSFORM_TEX(v.uv, _MainTex);
                    UNITY_TRANSFER_FOG(o,o.vertex);
                    return o;
                }

                [maxvertexcount(4)]
                void geom(line v2g v[2], inout TriangleStream<g2f> ts)
                {
                    g2f g[4];

                    //float4 p1 = UnityObjectToClipPos(v[0].vertex);
                    //float4 p2 = UnityObjectToClipPos(v[1].vertex);

                    float4 p1 = v[0].vertex;
                    float4 p2 = v[1].vertex;

                    float2 dir = normalize(p2.xy - p1.xy);
                    float2 normal = float2(-dir.y, dir.x);

                    //float4 offset1 = float4(normal * p1.w * _Thickness / 2.0f, 0, 0);
                    //float4 offset2 = float4(normal * p2.w * _Thickness / 2.0f, 0, 0);
                    float4 offset1 = float4(normal * _Thickness / 2.0f, 0, 0);
                    float4 offset2 = float4(normal * _Thickness / 2.0f, 0, 0);
                    offset1.x *= _ScreenParams.y / _ScreenParams.x;
                    offset2.x *= _ScreenParams.y / _ScreenParams.x;

                    float4 o1 = p1 + offset1;
                    float4 o2 = p1 - offset1;
                    float4 o3 = p2 + offset2;
                    float4 o4 = p2 - offset2;

                    g[0].vertex = o1;
                    g[1].vertex = o2;
                    g[2].vertex = o3;
                    g[3].vertex = o4;

                    g[0].uv = float2 (0, 0);
                    g[1].uv = float2 (1, 0);
                    g[2].uv = float2 (0, 1);
                    g[3].uv = float2 (1, 1);


                    ts.Append(g[0]);
                    ts.Append(g[1]);
                    ts.Append(g[2]);
                    ts.Append(g[3]);
                }

                fixed4 frag(g2f i) : SV_Target
                {
                    // sample the texture
                    fixed4 col = tex2D(_MainTex, i.uv);
                // apply fog
                UNITY_APPLY_FOG(i.fogCoord, col);
                return col;
            }
            ENDCG
        }
        }
}
